#!/bin/sh

# Shell script to install your public key on a remote machine
# Takes the remote machine name as an argument.
# The remote machine must accept password authentication or one of the other keys in your ssh-agent.

# Default identity files
ED25519_FILE="${HOME}/.ssh/id_ed25519.pub"
RSA_FILE="${HOME}/.ssh/id_rsa.pub"
ID_FILE=""

# Determine which key to use
if [ "-i" = "$1" ]; then
  shift
  # Check if we have 2 parameters left; if so, the first is the new ID file
  if [ -n "$2" ]; then
    if expr "$1" : ".*\.pub" > /dev/null; then
      ID_FILE="$1"
    else
      ID_FILE="$1.pub"
    fi
    shift # Leave $1 as the target name
  fi
else
  # Auto-detect the best key
  if [ -r "$ED25519_FILE" ]; then
    ID_FILE="$ED25519_FILE"
  elif [ -r "$RSA_FILE" ]; then
    ID_FILE="$RSA_FILE"
  else
    echo "$0: ERROR: No valid SSH public keys found" >&2
    exit 1
  fi
fi

# Use ssh-agent if available
if [ x$SSH_AUTH_SOCK != x ] && ssh-add -L >/dev/null 2>&1; then
  GET_ID="ssh-add -L"
fi

# Fall back to reading the identity file if no keys are in ssh-agent
if [ -z "`eval $GET_ID`" ] && [ -r "${ID_FILE}" ]; then
  GET_ID="cat ${ID_FILE}"
fi

if [ -z "`eval $GET_ID`" ]; then
  echo "$0: ERROR: No identities found" >&2
  exit 1
fi

# Validate usage
if [ "$#" -lt 1 ] || [ "$1" = "-h" ] || [ "$1" = "--help" ]; then
  echo "Usage: $0 [-i [identity_file]] [user@]machine" >&2
  exit 1
fi

# Strip any trailing colon
host=`echo $1 | sed 's/:$//'`

# Install the key on the remote machine
{ eval "$GET_ID" ; } | ssh $host "umask 077; test -d ~/.ssh || mkdir ~/.ssh ; cat >> ~/.ssh/authorized_keys" || exit 1

# Success message
cat <<EOF
Now try logging into the machine, with "ssh '$host'", and check in:

  ~/.ssh/authorized_keys

to make sure we haven't added extra keys that you weren't expecting.

EOF
